<?php
	if (isset($_POST["submit"])) {
		$name = isset($_POST['name']) ? htmlentities($_POST['name']) : '';
		$email = isset($_POST['email']) ? htmlentities($_POST['email']) : '';
		$phone = isset($_POST['phone']) ? htmlentities($_POST['phone']) : '';
		$message = isset($_POST['message']) ? htmlentities($_POST['message']) : '';
		$human = isset($_POST['human']) ? intval(htmlentities($_POST['human'])) : '';

		$to = 'davidfortier@mac.com'; 
		$subject = 'New Message from HAS Web Design';
		$headers = 'From: noreply@haswebdesign.com';

		$body ="From: $name\n E-Mail: $email\n Phone: $phone\n Message:\n $message\n";

		// Check if name has been entered
		if ($name == '') {
			$errName = 'Please enter your name.';
		}

		// Check if email has been entered and is valid
		if ($email == '' || !filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
			$errEmail = 'Please enter a valid email address.';
		}

		//Check if message has been entered
		if ($message == '') {
			$errMessage = 'Please enter your message.';
		}

		//Check if simple anti-bot test is correct
		if ($human !== 5) {
			$errHuman = 'Your anti-spam is incorrect.';
		}

		// If there are no errors, send the email
		if (!$errName && !$errEmail && !$errMessage && !$errHuman) {
			if (mail ($to, $subject, $body, $headers)) {
				$result='<div class="alert alert-success"><p>Thank You! We will be in touch.</p></div>';
			} else {
				$result='<div class="alert alert-error"><p>Sorry there was an error sending your message. Please try again later.</p></div>';
			}
		}
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>DES-390 | Contact Form</title>
<link href='https://fonts.googleapis.com/css?family=Open+Sans:400,300,700' rel='stylesheet' type='text/css'>
<style type="text/css">
html {
	margin:0px;
	padding:0px;
}
body {
	margin:0px;
	padding:0px;
	font:normal 400 12px/18px "Open Sans", "Trebuchet MS", Helvetica, Arial, sans-serif;
	color:#555555;
	background-color:#F7F7F7;
}

/* FORM */
.contact-form {
	margin:20px auto;
	padding:20px;
	width:530px;
	height:auto;
	background-color:#FFFFFF;
	border:1px solid #CCCCCC;
}
input, textarea {
	margin:0px 0px 10px 0px;
	padding:10px;
	font:normal 400 12px/18px "Open Sans", "Trebuchet MS", Helvetica, Arial, sans-serif;
	color:#555555;
	background-color:#F7F7F7;
	border:1px solid #CCCCCC;
}
input {
	width:300px;
}
textarea {
	min-width:300px;
	max-width:300px;
	min-height:100px;
	max-height:300px;
}
.row:after,.row:before{
	display:table;
	content:" ";
}
.row:after{
	clear:both;
}
.form-label {
	float:left;
	margin:0px;
	padding:0px;
	width:110px;
	height:auto;
}
.form-label > label {
	display:block;
	padding-top:5px;
	border-top:1px dotted #CCCCCC;
}
.form-input {
	float:left;
	margin:0px 0px 0px 20px;
	padding:0px;
	width:400px;
	height:auto;
}
.form-input p {
	font-size:10px;
	margin:-5px 0px 20px 0px;
}

/* BUTTONS */
input.btn-submit {
	width:100px;
}
a.btn, a.btn:link, a.btn:visited, a.btn:hover, a.btn:active, a.btn:focus, 
input.btn, input.btn:link, input.btn:visited, input.btn:hover, input.btn:active, input.btn:focus {
	display:inline-block;
	margin:0px;
	padding:8px 10px;
	font-weight:600;
	font-size:13px;
	line-height:20px;
	text-align:center;
	text-decoration:none;
	color:#FFFFFF;
	background-color:#89be0a;
	border:3px solid #89be0a;
}
a.btn:hover, input.btn:hover {
	color:#89be0a;
	background-color:#FFFFFF;
	border:3px solid #89be0a;
	cursor:pointer;
}

/* ALERT */
.alert {
	padding:15px;
	margin-bottom:20px;
	border:1px solid transparent;
	border-radius:4px;
}
.alert p {
	margin:0px;
	text-align:center;
}
.alert-success {
	color:#3c763d;
	background-color:#dff0d8;
	border-color:#d6e9c6;
}
.alert-error {
	color:#a94442;
	background-color:#f2dede;
	border-color:#ebccd1;
}
.text-error { color:#FF0000; }
</style>
</head>
<body>


<!-- BEGIN FORM -->
<form role="form" method="post" action="contact-form.php" class="contact-form">
    
    <!-- CONFIRMATION MESSAGE -->
    <?php echo $result; ?>

    <!-- NAME -->
    <div class="row">
        <div class="form-label">
            <label for="name">Name *</label>
        </div>
        <div class="form-input">
            <input type="text" id="name" name="name" placeholder="First & Last Name" value="<?php echo htmlspecialchars($_POST['name']); ?>">
            <?php echo "<p class='text-error'>$errName</p>";?>
        </div>
    </div>
    
    <!-- EMAIL -->
    <div class="row">
        <div class="form-label">
            <label for="email">Email *</label>
        </div>
        <div class="form-input">
            <input type="email" id="email" name="email" placeholder="example@domain.com" value="<?php echo htmlspecialchars($_POST['email']); ?>">
            <?php echo "<p class='text-error'>$errEmail</p>";?>
        </div>
    </div>
    
    <!-- PHONE -->
    <div class="row">
        <div class="form-label">
            <label for="phone">Phone</label>
        </div>
        <div class="form-input">
            <input type="text" id="phone" name="phone" placeholder="Phone" value="<?php echo htmlspecialchars($_POST['phone']); ?>">
        </div>
    </div>
    
    <!-- MESSAGE -->
    <div class="row">
        <div class="form-label">
            <label for="message">Message *</label>
        </div>
        <div class="form-input">
            <textarea rows="4" name="message" placeholder="Message"><?php echo htmlspecialchars($_POST['message']);?></textarea>
            <?php echo "<p class='text-error'>$errMessage</p>";?>
        </div>
    </div>
    
    <!-- SPAM FILTER -->
    <div class="row">
        <div class="form-label">
            <label for="human">Security Question: 2 + 3 = ? *</label>
        </div>
        <div class="form-input">
            <input type="text" id="human" name="human" placeholder="Answer">
            <?php echo "<p class='text-error'>$errHuman</p>";?>
        </div>
    </div>
    
    <!-- SEND BUTTON -->
    <div class="row">
        <div class="form-label">&nbsp;</div>
        <div class="form-input">
            <input id="submit" name="submit" type="submit" value="Submit" class="btn btn-submit">
        </div>
    </div>

</form> 
<!-- END FORM -->


</body>
</html>